/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFile.cpp,v 1.3 2000/05/13 06:34:20 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CFile.h"
#include "CFileImp.h"

_USING_PGP

// Class CFile member functions

DEFINE_IMPHOST(CFile, FileImp, CPFLImpFactory)

PGPBoolean 
CFile::IsOpened() const
{
	return Imp()->IsOpened();
}

PGPBoolean 
CFile::IsReadOnly() const
{
	return Imp()->IsReadOnly();
}

const char * 
CFile::Path() const
{
	return Imp()->Path();
}

#if PGP_EXCEPTIONS

PGPUInt64 
CFile::GetLength() const
{
	return Imp()->GetLength();
}

PGPUInt64 
CFile::GetUniqueFileId() const
{
	return Imp()->GetUniqueFileId();
}

#else	// !PGP_EXCEPTIONS

CComboError 
CFile::GetLength(PGPUInt64& length) const
{
	return Imp()->GetLength(length);
}

CComboError 
CFile::GetUniqueFileId(PGPUInt64& fileId) const
{
	return Imp()->GetUniqueFileId(fileId);
}

#endif	// PGP_EXCEPTIONS

SMART_ERROR 
CFile::SetIsCompressed(PGPBoolean isCompressed)
{
	SMART_ERROR_CALL Imp()->SetIsCompressed(isCompressed);
}

SMART_ERROR 
CFile::SetLength(PGPUInt64 length)
{
	SMART_ERROR_CALL Imp()->SetLength(length);
}

PGPBoolean 
CFile::IsFileInUseByReader(const char *path)
{
	return CFileImp::IsFileInUseByReader(path);
}

PGPBoolean 
CFile::IsFileInUseByWriter(const char *path)
{
	return CFileImp::IsFileInUseByWriter(path);
}

PGPBoolean 
CFile::IsFileInUse(const char *path)
{
	return CFileImp::IsFileInUse(path);
}

void 
CFile::Flush()
{
	Imp()->Flush();
}

SMART_ERROR 
CFile::Open(const char *path, PGPUInt32 flags)
{
	SMART_ERROR_CALL Imp()->Open(path, flags);
}

SMART_ERROR 
CFile::Close()
{
	SMART_ERROR_CALL Imp()->Close();
}

SMART_ERROR 
CFile::Delete(const char *path)
{
	SMART_ERROR_CALL Imp()->Delete(path);
}

SMART_ERROR 
CFile::Move(const char *oldPath, const char *newPath)
{
	SMART_ERROR_CALL Imp()->Move(oldPath, newPath);
}

SMART_ERROR 
CFile::Read(void *buf, PGPUInt64 pos, PGPUInt32 nBytes) const
{
	SMART_ERROR_CALL Imp()->Read(buf, pos, nBytes);
}

SMART_ERROR 
CFile::Write(const void *buf, PGPUInt64 pos, PGPUInt32 nBytes) const
{
	SMART_ERROR_CALL Imp()->Write(buf, pos, nBytes);
}
